//
//  FJDSortedArrayController.m
//  FJDItemsInFolderWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDSortedArrayController.h"


@implementation FJDSortedArrayController


- (void)dealloc
{
	[_indexKeyPath release], _indexKeyPath = nil;
	[_defaultSortDescriptors release], _defaultSortDescriptors = nil;
	
	[super dealloc];
}

#pragma mark Accessor methods

- (NSString*)indexKeyPath
{
	return _indexKeyPath;
}

- (void)setIndexKeyPath:(NSString*)keyPath
{
	[_indexKeyPath release], _indexKeyPath = nil;
	_indexKeyPath = [keyPath copy];
	
	// Set sort descriptors
//	NSSortDescriptor*   sortDescriptor;
//	sortDescriptor = [[NSSortDescriptor alloc] initWithKey:_indexKeyPath ascending:YES];
//	[self setSortDescriptors:[NSArray arrayWithObject:sortDescriptor]];
//	[sortDescriptor release];
}

- (NSArray *)defaultSortDescriptors
{
	if (_defaultSortDescriptors) {
		return _defaultSortDescriptors;
	} else {
		NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:_indexKeyPath ascending:YES];
		NSArray *array = [NSArray arrayWithObject:sortDescriptor];
		[sortDescriptor release];
		return array;
	}
}

- (void)setDefaultSortDescriptors:(NSArray *)value
{
	if (_defaultSortDescriptors != value) {
		[_defaultSortDescriptors release];
		_defaultSortDescriptors = [value copy];
	}
	
	[self setSortDescriptors:_defaultSortDescriptors];
}

- (BOOL)isSortedUsingDefaultDescriptors
{
	return [[self defaultSortDescriptors] isEqualToArray:[self sortDescriptors]];
}

// --- Different from ``content'' method defined in NSObjectController in the 
// point that this method retuns all objects of entity the array controller manages. 
// (``content'' method returns only objects specified by contentArray, 
// or contentSet binding, if it is set.)

- (NSArray *)allObjects
{
	NSManagedObjectContext *context      = [self managedObjectContext];
	NSFetchRequest         *fetchRequest = [[NSFetchRequest alloc] init];
	NSEntityDescription    *entity       = [NSEntityDescription entityForName:[self entityName]
													   inManagedObjectContext:context];
	[fetchRequest setEntity:entity];
	[fetchRequest setSortDescriptors:[self defaultSortDescriptors]];
	
	NSArray *result = [context executeFetchRequest:fetchRequest error:NULL];
	[fetchRequest release];
	return result;
}

#pragma mark Methods overriding NSArrayController

- (void)insertObject:(id)object atArrangedObjectIndex:(unsigned int)index
{
	[super insertObject:object atArrangedObjectIndex:index];
	
	[self reorderByMovingObjects:[NSArray arrayWithObject:object] toArrangedObjectIndex:index];
}

- (void)insertObjects:(NSArray *)objects atArrangedObjectIndexes:(NSIndexSet *)indexes
{
	[super insertObjects:objects atArrangedObjectIndexes:indexes];
	
	[self reorderByMovingObjects:objects toArrangedObjectIndex:[indexes firstIndex]];
}

#pragma mark Auxiliary methods that helps drag and drop

- (void)reorderByMovingObjects:(NSArray *)movedObjects toArrangedObjectIndex:(unsigned int)index
{
	if ([self isSortedUsingDefaultDescriptors]) {
		NSArray *arrangedObjects = [self arrangedObjects];
		
		// Get _indexKeyPath value at insertion point.
		long order = 0;
		if (index > 0) {
			NSManagedObject *objectJustAboveInsertion = [arrangedObjects objectAtIndex:index - 1];
			order = [[objectJustAboveInsertion valueForKey:_indexKeyPath] longValue] + 1;
		}
		
		NSEnumerator *enumerator = [movedObjects objectEnumerator];
		id object;
		
		// set the _indexKeyPath property of movedObjects incrementally.
		while (object = [enumerator nextObject]) {
			[object setValue:[NSNumber numberWithLong:order++] forKey:_indexKeyPath];
		}
		
		// set the _indexKeyPath properties of objects below the index.
		unsigned int i;
		for (i = index; i < [arrangedObjects count]; i++) {
			NSManagedObject *object = [arrangedObjects objectAtIndex:i];
			
			// if object is a member of movedObjects, do nothing (since _indexKeyPath is already set.)
			if ([movedObjects containsObject:object]) {
				continue;
			}
			
			// else, set _indexKeyPath property incrementally.
			[object setValue:[NSNumber numberWithUnsignedInt:order++] forKey:_indexKeyPath];
		}
	} else {
		// If controller is not sorted in the correct order, simply add the inserted item to last of the array.
		
		NSArray *sortedArray = [[self content] sortedArrayUsingDescriptors:[self defaultSortDescriptors]];
		
		long order = 0;
		if ([sortedArray count] > 0) {
			order = [[[sortedArray lastObject] valueForKey:_indexKeyPath] longValue] + 1;
		}
		
		NSEnumerator *enumerator = [movedObjects objectEnumerator];
		NSManagedObject *object;
		while (object = [enumerator nextObject]) {
			[object setValue:[NSNumber numberWithLong:order++] forKey:_indexKeyPath];
		}
	}
}

@end

